---
title: What to See in Paris
description: My experience in Paris, with parks, places to see, and things to do.
keywords: Paris promenade, parks in paris, where to eat in paris, how is it living in paris, short staying in paris
uuid: 067339d0-b83c-40e1-825b-fb636a45865e
publish: true
date: 2022-08-28
tags:
  - #kind/note
  - #topic/visiting
  - #about/paris
---

In the first months of this year, from January to April, I was in Paris for a period of study abroad at [INRIA](https://en.wikipedia.org/wiki/French_Institute_for_Research_in_Computer_Science_and_Automation) [(Archived)](https://web.archive.org/web/20220629/https://en.wikipedia.org/wiki/French_Institute_for_Research_in_Computer_Science_and_Automation). During these months I had time to visit the city in some depth, and I would like to suggest some places to visit if you have the opportunity to stay in Paris for some days.

<!-- More -->

**Places to See**
The places that one must see in Paris are mostly well-known and many of them are served by the M1 metro line.
However I was shocked to realize that one could just go for a walk along the river and see all of them much better than just passing by from one metro station to the other, and I strongly advise visiting the city in this way.
To help you I prepared the [path on Google Maps](https://www.google.com/maps/dir/Place+de+la+Bastille,+Pl.+de+la+Bastille,+75004+Paris,+Francia/H%C3%B4tel+de+Ville/48.8536432,2.3482059/Pont+Neuf/Mus%C3%A9e+du+Louvre/Jardin+des+Tuileries/Petit+Palais/Palais+de+Tokyo,+President+Wilson+Avenue,+Parigi,+Francia/Jardins+du+Trocad%C3%A9ro/@48.8254791,2.241923,12.86z/data=!3m1!5s0x47e66fd1ce997a89:0xf5601734132c64fb!4m51!4m50!1m5!1m1!1s0x47e67201aca99229:0x231eb0c967e5eb10!2m2!1d2.3691305!2d48.8531861!1m5!1m1!1s0x47e66e1dc0611361:0x3df254a015ae71ea!2m2!1d2.3522047!2d48.8572513!1m0!1m5!1m1!1s0x47e66e2054122d61:0x1610ba55401fe480!2m2!1d2.3421855!2d48.8584354!1m5!1m1!1s0x47e671d877937b0f:0xb975fcfa192f84d4!2m2!1d2.337644!2d48.8606111!1m5!1m1!1s0x47e66e2c30000001:0xc219db09e1bfefc7!2m2!1d2.3274943!2d48.8634916!1m5!1m1!1s0x47e66fd1ce8f4349:0xf3f5be813dd2469c!2m2!1d2.3145896!2d48.8660479!1m5!1m1!1s0x47e66fe6f937420b:0xc92ed17a5e1ca31d!2m2!1d2.2966748!2d48.8645866!1m5!1m1!1s0x47e66fe3473716a3:0xe9200d1a1843c45a!2m2!1d2.2892823!2d48.8615963!3e2) and you can find below a quick description of the key points of the walk.
<details>
<summary>Walk along the river</summary>
Starting from *Place de la Bastille* head to *Saint-Paul* neighborhood where you can do a quick deviation to see *Place des Vosges*, and then continue straight until the *Hotel de Ville*.
Now by crossing the river you can visit the *Cathédrale de Notre-Dame* and then head back to the riverside to see the *Louvre* and the *Jardins des Tuileries*, optionally with another quick deviation to *Place Vendome*.
Then continue by the river until you came by the *Petit et Grand Palais*, then visit the *Palais de Tokyo* and the path ends in the *Jardin de Trocadero*, just in front of the *Tour Eiffel*.

At the *Trocadero* metro station I suggest you to take the M6 line to *Nation* to enjoy the panoramic view on the Eiffel Tower, some wall paintings on skyscrapers in the asian quartier and a beautiful view over the river.
It will also bring you very near the start of the walk where you can continue to other sites, or you can jump off at *Bercy* and take the M14 to *Cour Saint Emilion* to rest in the *Parc de Bercy* or to eat at the *Bercy Village*.
</details>

Of course the walk doesn't cover all the "must see" places in Paris, and you may also want to visit *Les Invalides*, *Montmartre* and the *Sacre Coeur*, and also go for a walk on the *Champs Elyseé*.
However I suggest to also go to see *Montparnasse*, a nice quartier which hosts the *Catacombs*, where the bones of more than two millions people are stored, some also in nice and macabre artistic schemes.

Paris is also full of museums, both the well-known ones of arts and sculptures (*Museé du Louvre*, *Museé Pompidou*, *Museé d'Orsay*), and many other smaller and more peculiar ones.
Unfortunately I do not have one to recommend, but be sure to look a little bit on the web, since you may find something that captures your interest.

**Parks**
Paris has a lot of green spaces, and I like it very much that you can find a park near you almost anywhere you are.
Of the many that I have seen, I definitely recommend you to spend some time in the *Parc de Buttres-Chaumont*, which is an old cave transformed into a park with breathtaking views, ideal for a picnic, and the *Parc de Bercy*, organized in many different pieces curated in different styles, with many ducks living in it.

Moreover, if you are nearby the *12ème arrondissment* I suggest that you try to go for a beautiful walk in many green areas around. I think it is very instructive to see how such a big city can still give you the opportunity to traverse it remaining in the green (see the [path on Google Maps](https://www.google.com/maps/dir/Picpus,+75012+Parigi,+Francia/48.83873,2.4064036/48.8411302,2.3986463/48.8421143,2.3884205/48.84396,2.3827732/48.8495981,2.3713176/@48.838891,2.3858667,14.61z/data=!4m13!4m12!1m5!1m1!1s0x47e6725d77270759:0x1b2e5458820b8a35!2m2!1d2.4013417!2d48.8341465!1m0!1m0!1m0!1m0!1m0!3e2)), and going from the *Bastille* to the *Coulée Vert René-Dumont*, then through the *Jardin de Reuilly* and the *Allée Vivaldi* which brings you to *La Promenade Plantée*, continuing into the *Square Charles Péguy* and finally see the *Petite Ceinture du 12ème*, an old elevated railway which has been converted into a green area inside the city, with views on many beautiful houses. 

Indeed I suggest you to take a closer look at the architecture of the city and to observe how the buildings are built in a common style and many variations around the same pattern, which make each floor different from the others.

**Places to Eat**
Due to the high concurrency and rent prices, I would say that only good enough *boulangeries* and restaurants survive, so that you can usually choose one that you find nearby and eat well. Of course this does *not* include those that are too near famous monuments, as these will thrive with tourism whether they are good or not.

For breakfast or a little snack during the day, the *boulangeries* are really awesome, with their full choice of baked pastries (*viennoiserie*). The queue outside is a good indicator of the quality of the pastries, and it is usually quite fast.
If you absolutely want to get the best quality, look for those that have won the prize "Best baguette" in past years.

If you are there for some months and are craving for pizza, many have suggested me to go in *PIzzeria Popolare*, although you absolutely have to reserve for it well in advance, since they are always full.

Specific places that I would recommend are *Ground Control*, a very nice and curated place for an aperitif with friends where you will find many different stands of food and beverages, the possibility to practice table tennis and a small library; and either the *Gros Bao* or the *Petit Bao*, very good asian restaurants specialized in bao.
For these latter it is better to reserve in advance or to go there very early, since they also tend to be quite full.

If you are not sure what you want to eat you can go to *Bercy Village* where you will find a variety of restaurants, from typical French cuisine (and a place specialized in *gallettes*) to the *Hanoi Ca-phe* serving thai food.

**Other Activities**
To go out with friends there are many cocktail bars serving creative cocktails, or if you have an afternoon to spend and want a somewhat unusual activity to do, you will find many bouldering bars with a cheap first-climbing offer.

You will also find essentially everything you want in Paris since it is so big a city, but what stroke me is that it is quite livable and there are rare moments where you feel like you have just too many people around you (metro commuting hours apart).
Many of the everyday things like buying groceries and doing laundry happen in your neighborhood, and many times you have the relaxing feeling of living in a middle-sized city.
